/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, Modernizr, define, navigator, window */

'use strict';
define([ 'jquery', 'underscore', 'Portal', 'modernizr' ], function ($, _, Portal) {
    return (function () {
        var _auth = {};

        _auth.authenticate = function () {
            var deferred = $.Deferred();

            _auth.parseToken();

            Portal.userSession().fetch({
                url: Portal.resources().get('mhpuser').get('href')
            }).done(function (data) {
                // for pages that require non-authenticated access, comment out if statement below
                if (!data.displayName) {
                    var loginUrl = Portal.resources().get('oauth-login').get('href');
                    _auth.gotoLoginWithRedirect(loginUrl);
                }
                deferred.resolve();
            }).fail(function (response) {
                deferred.reject();
            });

            return deferred.promise();
        };

        _auth.deleteCookie = function (cookieName) {
            document.cookie = encodeURIComponent(cookieName) + '=deleted; expires=' + new Date(0).toUTCString();
        };

        _auth.deleteToken = function (token) {
            return $.ajax({
                url: Portal.resources().get('token').get('href'),
                type: 'DELETE'
            });
        };

        _auth.wipeSessionData = function () {
            var deferred = $.Deferred();
            var storedToken = sessionStorage['token'],
                currentToken = '';
            if (typeof storedToken !== 'undefined') {
                currentToken = JSON.parse(storedToken);
                _auth.deleteToken(currentToken).always(function () {
                    sessionStorage.removeItem('token');
                    $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
                        jqXHR.setRequestHeader('Authorization', '');
                    });
                    _auth.deleteCookie('JSESSIONID');
                    deferred.resolve();
                });
            } else {
                deferred.resolve();
            }
            return deferred.promise();
        };

        _auth.parseToken = function () {
            var params = {},
                queryString = location.search.substring(1),
                regex = /(token)=([0-9a-zA-Z\-]*)/g,
                m,
                token,
                storedToken;

            m = regex.exec(queryString);
            while (m) {
                params[decodeURIComponent(m[1])] = decodeURIComponent(m[2]);
                m = regex.exec(queryString);
            }

            token = params.token;
            if (token !== undefined && token !== 'undefined' && token !== null && token !== 'null') {
                sessionStorage.setItem('token', JSON.stringify(token));
            }

            storedToken = sessionStorage.getItem('token');
            if (storedToken !== undefined && storedToken !== 'undefined' && storedToken !== null && storedToken !== 'null') {
                $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
                    var currentToken = JSON.parse(storedToken);
                    jqXHR.setRequestHeader("Authorization", "Bearer " + currentToken);
                });
            } else {
                _auth.wipeSessionData();
            }

            //_auth.stripToken();
        };

        _auth.stripToken = function () {
            /*
             * There's some bug with replaceState, when token is stripped, clicking on button to # breaks app
            if (window.location.search.indexOf('token') > -1) {
                var newURL = window.location.protocol + "//" + window.location.host + window.location.pathname + '#',
                    tokenRegEx = /(token)=([0-9a-zA-Z\-]*)/g;

                if (Modernizr.history) {
                    window.history.replaceState({hash: newURL, url: newURL}, 'removeToken', newURL);
                    
                    $('[href]').each(function () {
                        this.href = this.href.replace(tokenRegEx, "").replace("?&", "?").replace(/\?$/, "");
                    });
                } else {
                    window.location.replace(newURL);
                }
            }
            */
            return undefined;
        };

        _auth.gotoLoginWithRedirect = function (loginUrl) {
            _auth.wipeSessionData().done(function () {
                _auth.fixIEOrigin();
                window.location.href = loginUrl + "?redirect_uri=" + window.location.origin + window.location.pathname + window.location.hash;
            });
        };

        _auth.gotoLogoutWithRedirect = function (logoutUrl) {
            _auth.wipeSessionData().done(function () {
                _auth.fixIEOrigin();
                window.location.href = logoutUrl + "?redirect_uri=" + window.location.origin + window.location.pathname;
            });
        };
        _auth.fixIEOrigin = function() {
			if (!window.location.origin) {
				window.location.origin = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port: '');
			}
        };

        return _auth;
    }());
});